/*
 * choose servo on myservo.attach() call
 * choose startpos and endpos for servo sweep 
 * the calibration test starts automatically
 * start and stop test touchung ground on pin 2 and 3
 */

#include <Servo.h>
Servo myservo;

// position in degrees 
int pos = 0;  // changing during test
int startpos = 5;
int endpos = 40;

// pin-servo mapping
int base = 11; // 59-145
int shoulder = 10; // 80-120
int elbow = 9;  // 90-140
int wrist = 6; // 30-150 (0 al centro)
int gripper = 5; // 5-50

// interrupt pins (2-3 only for Uno boards)
int turnOn = 2; // interrupt pin with internal pullup
int turnOff = 3; // interrupt pin with internal pullup
volatile bool runTest = true;

void setup() {
  pinMode(turnOn, INPUT_PULLUP);
  pinMode(turnOff, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(turnOff), stopTest, FALLING);
   attachInterrupt(digitalPinToInterrupt(turnOn), startTest, FALLING);
  myservo.attach(gripper);
}

// IRS when pin 3 touches GND
void stopTest() {
    runTest = false;
}

// IRS when pin 2 touches GND
void startTest() {
    runTest = true;
}

void loop() {
  // sweep servo position
  if (runTest == true) {
    for (pos = startpos; pos <= endpos; pos += 1) {
      if (not runTest) {
        break;
      }
      myservo.write(pos);
      delay(20);
    }
    // pause before going backwards
    delay(500);
    for (pos = endpos; pos >= startpos; pos -= 1) {
      if (not runTest){
        break;
      }
      myservo.write(pos);
      delay(20);
    }
    // pause again
    delay(500);
  }
}
