/*  da https://www.mauroalfieri.it/bricolage/posizionamento-braccio-robot.html#more-12400
 *  aggiunto start-stop da seriale
 *  le posizioni vanno ricalibrate in base al nostro robot
 *  i movimenti sono rallentati usando la funzione goPos()
 */
 
#include <Servo.h>
 
// per il range di valori vedi qui
// https://leonardocanducci.org/wiki/tp4/braccio_robotico#collaudo
Servo base;         // 1 0 - 180    59-145
Servo shoulder;     // 2 140 - 37   80-120
Servo elbow;        // 3 65 - 140   90-140
Servo wrist_rot;    // 4 0 - 180    30-150
Servo gripper;      // 5 0 - 75     5-50
 
// posizione iniziale
byte pos[5]    = {60,100,130,90,0}; // era {90,90,90,90,0}
// serve per la funzione goPos()
byte oldpos[5] = {60,100,130,90,0};
 
byte seq[][5] = {
  {60,100,130,90,0},
  {140,100,130,90,0},
  {140,100,110,90,0},
  {140,65,110,90,0},
  {140,65,110,90,35},
  {140,100,110,90,35},
  {60,100,110,90,35},
  {60,65,110,90,35},
  {60,65,110,90,0},
  {60,100,130,90,0}
};
 
// avvio se arriva del testo da seriale
bool run = false;
 
void setup() {
  Serial.begin(9600);
 
  // abbinamento servo-pin
  base.attach(11);
  shoulder.attach(10);
  elbow.attach(9);
  wrist_rot.attach(6);
  gripper.attach(5);
 
  // comando posizione iniziale
  base.write(pos[0]);
  shoulder.write(pos[1]);
  elbow.write(pos[2]);
  wrist_rot.write(pos[3]);
  gripper.write(pos[4]);
 
  Serial.println( "#### invia testo per avviare e per fermare la sequenza ####" );
}
 
void loop() {
 
  startStop();
  while (run) {
 
    for ( byte line=0; line < (sizeof(seq)/5); line++ ) {
      Serial.print("Seq["); Serial.print(line); Serial.print("]:"); 
      for( byte i=0; i<5; i++ ) {
        Serial.print(" "); Serial.print(seq[line][i]); 
        pos[i] = seq[line][i];
      }
      Serial.print("\n");
      goPos(0,base,15);
      goPos(1,shoulder,15);
      goPos(2,elbow,15);
      goPos(3,wrist_rot,15);
      goPos(4,gripper,15);
      delay(1000);
      startStop();
    }
    delay(2000);
  }
}
 
void goPos(byte servo, Servo instance, byte pause) {
   if (oldpos[servo] >= pos[servo]) {
      for ( byte i = oldpos[servo]; i > pos[servo]; i--) {
        instance.write(i);
        delay(pause);
      }
   }
   if (oldpos[servo] <= pos[servo]) {
      for ( byte i = oldpos[servo]; i < pos[servo]; i++) {
        instance.write(i);
        delay(pause);
      }
   }
   oldpos[servo] = pos[servo];
}
 
void startStop() {
  // se arriva del testo dal monitor seriale
  if (Serial.available()>0){
    // senza questo ritardo non legge tutti i dati del buffer!
    delay(10);
    Serial.println("buffer non vuoto");
    Serial.print("buffer dati: ");
    Serial.println(Serial.available());
    // svuota il buffer
    clearInputBuffer();
    Serial.print("buffer dati: ");
    Serial.println(Serial.available());
    // toggle della variabile che attiva la sequenza
    run = !run;
    Serial.print("run vale: ");
    Serial.println(run);
  }
}
 
void clearInputBuffer() {
  while (Serial.available() > 0) {
    char t = Serial.read();
  }
}
