#include <Servo.h>
 
// per il range di valori vedi qui
// https://leonardocanducci.org/wiki/tp4/braccio_robotico#collaudo
Servo base;         // 59-145
Servo shoulder;     // 80-120
Servo elbow;        // 90-140
Servo wrist_rot;    // 30-150
Servo gripper;      // 5-50
 
// posizione iniziale
byte pos[5]    = {60,100,130,90,0};
// serve per la funzione goPos()
byte oldpos[5] = {60,100,130,90,0};

// sequenza posizioni
byte seq[][5] = {
  {60,100,130,90,0},
  {140,100,130,90,0},
  {140,100,110,90,0},
  {140,65,110,90,0},
  {140,65,110,90,35},
  {140,100,110,90,35},
  {60,100,110,90,35},
  {60,65,110,90,35},
  {60,65,110,90,0},
  {60,100,130,90,0}
};
 
// avvio con interrupt dal pin 2
int onOff = 2;
volatile bool run = true;
 
void setup() {
  Serial.begin(9600);
  pinMode(onOff, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(onOff), toggle, FALLING);
 
  // abbinamento servo-pin
  base.attach(11);
  shoulder.attach(10);
  elbow.attach(9);
  wrist_rot.attach(6);
  gripper.attach(5);
 
  // comando posizione iniziale
  base.write(pos[0]);
  shoulder.write(pos[1]);
  elbow.write(pos[2]);
  wrist_rot.write(pos[3]);
  gripper.write(pos[4]);
 
  Serial.println( "#### sequenza ####" );
}

void toggle() {
  run = false;
}

void loop() {
 
  while (run) {
 
    for ( byte line=0; line < (sizeof(seq)/5); line++ ) {
      Serial.print("Seq["); Serial.print(line); Serial.print("]:"); 
      for( byte i=0; i<5; i++ ) {
        Serial.print(" "); Serial.print(seq[line][i]); 
        pos[i] = seq[line][i];
      }
      Serial.print("\n");
      goPos(0,base,15);
      goPos(1,shoulder,15);
      goPos(2,elbow,15);
      goPos(3,wrist_rot,15);
      goPos(4,gripper,15);
      delay(1000);
    }
    delay(2000);
  }
}
 
void goPos(byte servo, Servo instance, byte pause) {
   if (oldpos[servo] >= pos[servo]) {
      for ( byte i = oldpos[servo]; i > pos[servo]; i--) {
        instance.write(i);
        delay(pause);
      }
   }
   if (oldpos[servo] <= pos[servo]) {
      for ( byte i = oldpos[servo]; i < pos[servo]; i++) {
        instance.write(i);
        delay(pause);
      }
   }
   oldpos[servo] = pos[servo];
}
